import { Injectable } from '@angular/core';
import { NgRedux } from 'ng2-redux';

import {
  BOOKMARK_ICON_FOCUSED,
  BOOKMARK_ICON_UNFOCUSED,
  SEARCH_ICON_FOCUSED,
  SEARCH_ICON_UNFOCUSED,
  UPDATE_ACTIVE_ICON,
  FOCUS_ON
} from '../actions';
import { IAppState } from '../store';

@Injectable()
export class SideNavigationService {
  constructor(private ngRedux: NgRedux<IAppState>) {}

  getState() {
    return this.ngRedux.getState();
  }

  setActiveIcon(type) {
	// setTimeout(() => {
    setTimeout(() => {
      this.ngRedux.dispatch({
        type: UPDATE_ACTIVE_ICON,
        payload: type
      });
    }, 500);
		// this.ngRedux.dispatch({
		//   type: FOCUS_ON,
		//   payload: ''
		// });
	// }, 500);
  }

  getActiveIcon() {
    return this.getState().sideNavigation.activeIcon;
  }

  disableActiveIcon(disabledType) {
	setTimeout(() => {
		this.ngRedux.dispatch({
		  type: FOCUS_ON,
		  payload: disabledType
		});
		this.ngRedux.dispatch({
		  type: UPDATE_ACTIVE_ICON,
		  payload: ''
		});
	}, 500);
  }

  isExpanded() {
    return this.getState().sideNavigation.activeIcon !== '';
  }

  isActive(type) {
    return this.getState().sideNavigation.activeIcon === type;
  }
}